/* Copyright (c) 2008, Oracle. All rights reserved. */

import java.io.*;

public class LASPointDataRecordFormat0 extends LASPointDataRecord {

	public LASPointDataRecordFormat0() {
	  super();
	}

	public void parse(InputStream inputStream, int pointDataRecordLength) {
	  super.parse(inputStream,pointDataRecordLength);
	  try {
	    int bytesRemaining=pointDataRecordLength-20;
	    extraData = new byte[bytesRemaining];
	    inputStream.read(extraData);
	  }
          catch (IOException exception) {
	    exception.printStackTrace();
	  }
	}

	public void write(OutputStream outputStream, int pointDataRecordLength) {
	  super.write(outputStream,pointDataRecordLength);
	  try{
	    if ((extraData != null) && (extraData.length != 0)) {
	      outputStream.write(extraData);
	    }
	  }
          catch (IOException exception) {
	    exception.printStackTrace();
	  }
	}

	public void print() {
	  super.print();
	  System.out.println("extra data: " + arrayToBits(extraData));
	}
}
